; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Phase 3VL"
!define PRODUCT_VERSION "2.0.2.0"

!define PROGRAM_FILENAME "phase3vl"
!define DATA_DIR "$APPDATA\Datrend\Phase 3VL\"
!define SETUP_FILENAME "Phase3VLV202Setup.exe"

!define COMPANY_NAME "Datrend"
!define PRODUCT_PUBLISHER "Datrend Systems Inc."
!define PRODUCT_WEB_SITE "http://www.datrend.com"

!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PROGRAM_FILENAME}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

!define DEV_DIR "D:\src\AS-018f Phase 3VL V2.0.1.0"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE "${DEV_DIR}\Installer\EULA.txt"

; Components page
!insertmacro MUI_PAGE_COMPONENTS

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "${COMPANY_NAME}\${PRODUCT_NAME}"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Function .onInit
   System::Call 'kernel32::CreateMutexA(i 0, i 0, t "phase3vl") i .r1 ?e'
   Pop $R0
   StrCmp $R0 0 +3
   MessageBox MB_OK|MB_ICONEXCLAMATION "The installer is already running."
   Abort
FunctionEnd

Name "${COMPANY_NAME} ${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${SETUP_FILENAME}"
InstallDir "c:\${COMPANY_NAME}\${PRODUCT_NAME}"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "${PRODUCT_NAME}" SECTION_PHASE3VL
   SectionIn RO
   WriteRegStr HKLM "Software\${COMPANY_NAME}\${PRODUCT_NAME}" "DataDir" "${DATA_DIR}"
    
   SetOutPath "$INSTDIR"
   SetOverwrite ifnewer
   File "${DEV_DIR}\App\${PROGRAM_FILENAME}.exe"
   File "${DEV_DIR}\Help\${PROGRAM_FILENAME}.chm"
   File "${DEV_DIR}\Default Data\${PROGRAM_FILENAME}.exe.manifest"

   SetOutPath "${DATA_DIR}"
   SetOverwrite off
   File "${DEV_DIR}\Default Data\${PROGRAM_FILENAME}.ini"

   ; Shortcuts
   !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
   CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
   CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\${COMPANY_NAME} ${PRODUCT_NAME}.lnk" "$INSTDIR\${PROGRAM_FILENAME}.exe"
   !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -AdditionalIcons
   SetOutPath $INSTDIR
   !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
   WriteIniStr "$INSTDIR\${COMPANY_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
   CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\${COMPANY_NAME} Website.lnk" "$INSTDIR\${COMPANY_NAME}.url"
   CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall ${PRODUCT_NAME}.lnk" "$INSTDIR\uninst.exe"
   !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section "Desktop Icon" SecDesktop
   CreateShortCut "$DESKTOP\${COMPANY_NAME} ${PRODUCT_NAME}.lnk" "$INSTDIR\${PROGRAM_FILENAME}.exe"
SectionEnd

Section "Quick Launch Icon" SecQuick
   CreateShortCut "$QUICKLAUNCH\${COMPANY_NAME} ${PRODUCT_NAME}.lnk" "$INSTDIR\${PROGRAM_FILENAME}.exe"
SectionEnd

Section -Post
   WriteUninstaller "$INSTDIR\uninst.exe"
   WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PROGRAM_FILENAME}.exe"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PROGRAM_FILENAME}.exe"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
   WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

;--------------------------------
;Descriptions
 
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SECTION_PHASE3VL} "Install Phase 3VL Variable Load Module software."
!insertmacro MUI_FUNCTION_DESCRIPTION_END
 
Function un.onUninstSuccess
   HideWindow
   MessageBox MB_ICONINFORMATION|MB_OK "${PRODUCT_NAME} was successfully removed from your computer."
FunctionEnd

Function un.onInit
   MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove ${PRODUCT_NAME} and all of its components?" IDYES +2
   Abort
FunctionEnd

Section Uninstall
   !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

   Delete "$INSTDIR\${COMPANY_NAME}.url"
   Delete "$INSTDIR\${PROGRAM_FILENAME}.exe"
   Delete "$INSTDIR\${PROGRAM_FILENAME}.chm"
   Delete "$INSTDIR\${PROGRAM_FILENAME}.exe.manifest"
   Delete "$INSTDIR\uninst.exe"
   RMDir "$INSTDIR"

   Delete "${DATA_DIR}\${PROGRAM_FILENAME}.ini"
   RMDir "${DATA_DIR}"

   Delete "$QUICKLAUNCH\${COMPANY_NAME} ${PRODUCT_NAME}.lnk"
   Delete "$DESKTOP\${COMPANY_NAME} ${PRODUCT_NAME}.lnk"
   Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall ${PRODUCT_NAME}.lnk"
   Delete "$SMPROGRAMS\$ICONS_GROUP\${COMPANY_NAME} Website.lnk"
   Delete "$SMPROGRAMS\$ICONS_GROUP\${COMPANY_NAME} ${PRODUCT_NAME}.lnk"
   RMDir "$SMPROGRAMS\$ICONS_GROUP"
  
   DeleteRegValue HKLM "Software\${COMPANY_NAME}\${PRODUCT_NAME}" "DataDir"
   DeleteRegKey HKLM "Software\${COMPANY_NAME}\${PRODUCT_NAME}\"
   DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
   DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
   SetAutoClose true
SectionEnd
